<?php
header('Content-Type: application/json');

// Dev info
$developer = "Dev By Raj";
$telegram = "@tg71admin";

// Dhaka time setup
date_default_timezone_set("Asia/Dhaka");

// WinGo history URL
$historyUrl = "https://draw.ar-lottery01.com/WinGo/WinGo_30S/GetHistoryIssuePage.json?ts=" . round(microtime(true)*1000);

// Fetch Data
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $historyUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
$response = curl_exec($ch);
curl_close($ch);

if(!$response){
    echo json_encode([
        "status" => "error",
        "message" => "API connection failed"
    ]);
    exit;
}

$data = json_decode($response, true);

if(!isset($data['data']['list'][0])){
    echo json_encode([
        "status" => "error",
        "message" => "No data found"
    ]);
    exit;
}

$list = $data['data']['list'];
$last = $list[0];

// Normal market check
$p = intval($last['premium']);
$market = ($p >= 6) ? "BIG" : "SMALL";

// Last 5 numbers
$last5 = [];
$sum = 0;

for($i = 0; $i < 5; $i++){
    if(isset($list[$i]['number'])){
        $n = intval($list[$i]['number']);
        $last5[] = $n;
        $sum += $n;
    }
}

// digit sum
$digitSum = array_sum(str_split($sum));

// Search in history for last digitSum match
$mainSignal = "SKIP";
foreach($list as $row){
    if(intval($row['number']) == $digitSum){
        $pp = intval($row['premium']);
        $mainSignal = ($pp >= 6) ? "BIG" : "SMALL";
        break;
    }
}

// ðŸ”¹ Check if any 0 in last 5 numbers, flip finalSignal for display
$displaySignal = $mainSignal;
if(in_array(0, $last5)){
    $displaySignal = ($mainSignal === "BIG") ? "SMALL" : "BIG";
}

$result = [
    "number1" => $last['issueNumber'],      // PERIOD ID
    "lastNumber" => $last['number'],
    "marketSignal" => $market,
    "last5" => $last5,
    "sum" => $sum,
    "digitSum" => $digitSum,
    "finalSignal" => $mainSignal,          // Actual calculated signal
    "displaySignal" => $displaySignal      // Flipped if any 0 in last 5
];

echo json_encode([
    "status" => "success",
    "result" => $result
], JSON_PRETTY_PRINT);
?>