<?php
header('Content-Type: application/json');

// Function to get JSON data from a PHP file (even if it echoes JSON)
function getApiData($file) {
    ob_start();
    include($file);
    $json = ob_get_clean();
    return json_decode($json, true);
}

// Fetch data
$signalData = getApiData('signal2.php');
$last2Data  = getApiData('last2.php');

// Validate
if(!isset($signalData['result']['finalSignal']) || !isset($last2Data['marketSignal'])) {
    echo json_encode([
        "status" => "error",
        "message" => "Invalid API response"
    ], JSON_PRETTY_PRINT);
    exit;
}

// Uppercase signals
$finalSignal  = strtoupper($signalData['result']['finalSignal']);
$marketSignal = strtoupper($last2Data['marketSignal']);

// Compare signals
$result = ($finalSignal === $marketSignal) ? "win" : "loss";

// Pretty JSON response
$response = [
    "status" => "success",
    "finalSignal" => $finalSignal,
    "marketSignal" => $marketSignal,
    "result" => $result,
    "developer" => "Dev By Raj",
    "telegram" => "@tg71admin"
];

echo json_encode($response, JSON_PRETTY_PRINT);